/**
 * @license Copyright (c) 2003-2015, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {

    config.language = 'nl';

    /* 2. via: http://kk-an-----tonius-all.kijk-tv.nl/kk-an-----tonius-edit/ckeditor/samples/toolbarconfigurator/index.html#basic
     config.toolbarGroups = [
        { name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
        { name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
        { name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },
        { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
        { name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi', 'paragraph' ] },
        { name: 'links', groups: [ 'links' ] },
        { name: 'insert', groups: [ 'insert' ] },
        { name: 'styles', groups: [ 'styles' ] },
        { name: 'colors', groups: [ 'colors' ] },
        { name: 'tools', groups: [ 'tools' ] },
        { name: 'others', groups: [ 'others' ] },
        { name: 'about', groups: [ 'about' ] }
    ];
    */

/* 1. handmatig  */
    config.toolbar = [
        [ 'Source', '-', '-', 'Font', 'TextColor','FontSize','align','colorbutton','HorizontalRule','colordialog' ],
        [ 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo' , 'Table', 'CleanUp' ],
        '/',
        [ 'SpecialChar','Bold', 'Italic', 'NumberedList', 'BulletedList', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'Outdent', 'Indent', 'Image', 'Link', 'Format','RemoveFormat']
    ];

    config.removeButtons = 'Save,NewPage,Preview,Templates,Form,HiddenField,ImageButton,Button,Select,Textarea,TextField,Radio,Checkbox,Blockquote,CreateDiv,BidiLtr,BidiRtl,Language,Unlink,Anchor,Flash,Iframe,Maximize,ShowBlocks';

    config.enterMode = CKEDITOR.ENTER_BR;
    config.toolbarLocation = 'bottom';

    config.extraPlugins = 'tableresize';

    config.extraAllowedContent = 'div(*)';
    config.allowedContent = true;


     /*
     config.contentsCss = [ 'http://kk-nederh-all.kijk-tv.nl/kk-nederh-edit/kk-ksmit-contents.css'];
     */

    /*
    config.contentsCss = [ 'http://centrale.kijk-tv.nl/css_000_1_sitebasic.css' ,
        'http://centrale.kijk-tv.nl/css_000_2_style_to_classes.css' ,
        'http://centrale.kijk-tv.nl/css_000_2_style_to_classes.css',
        'http://centrale.kijk-tv.nl/css_001_6_edit.css','http://centrale.kijk-tv.nl/css_001_7_edit_kabelkrant.css'
    ];
    */

};

CKEDITOR.on('dialogDefinition', function( ev ) {
    var dialogName = ev.data.name;
    var dialogDefinition = ev.data.definition;

    if(dialogName === 'table') {
        var infoTab = dialogDefinition.getContents('info');
        var cellSpacing = infoTab.get('txtCellSpace');
        cellSpacing['default'] = "0";
        var cellPadding = infoTab.get('txtCellPad');
        cellPadding['default'] = "0";
        var border = infoTab.get('txtBorder');
        border['default'] = "0";
        var width = infoTab.get('txtWidth');
        width['default'] = "99.888%";
    }
});




/*

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here. For example:
	// config.uiColor = '#AADC6E';

    config.toolbar = [
        [ 'Source', '-', '-', 'Font', 'TextColor','FontSize','align','colorbutton','HorizontalRule','colordialog' ],
        [ 'Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo' , 'Table', 'CleanUp' ],
        '/',
        [ 'SpecialChar','Bold', 'Italic', 'NumberedList', 'BulletedList', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'Outdent', 'Indent', 'Image','Format','RemoveFormat']
    ];





};

*/
